﻿Option Strict On
Option Explicit On
Option Infer Off

Imports System.Threading

Module Module1

    Private r As Random = New Random()
    Const ileWatkow As Integer = 10
    'ReadOnly ileWatkow As Integer = System.Environment.ProcessorCount
    Private pi As Double = 0

    Sub Main()
        'uruchamianieObliczenPi()

        Dim czasPoczatkowy As Integer = Environment.TickCount

        'uruchamianie obliczen
        Dim ts As ThreadStart = New ThreadStart(AddressOf uruchamianieObliczenPi)
        Dim tt(ileWatkow - 1) As Thread
        For i As Integer = 0 To ileWatkow - 1
            tt(i) = New Thread(ts)
            tt(i).Priority = ThreadPriority.Lowest
            tt(i).Start()
        Next

        'czekanie na zakończenie wątków
        For Each t As Thread In tt
            t.Join()
            Console.WriteLine("Zakończył działanie wątek nr {0}", t.ManagedThreadId)
        Next
        pi /= ileWatkow
        Console.WriteLine("Wszystkie wątki zakończyły działanie." & vbNewLine & "Uśrednione Pi={0}, błąd={1}", pi, Math.Abs(Math.PI - pi))

        Dim czasKoncowy As Integer = Environment.TickCount
        Dim roznica As Integer = czasKoncowy - czasPoczatkowy
        Console.WriteLine("Czas obliczeń: " & roznica.ToString())
    End Sub

    Private Function obliczPi(ilośćPrób As Long) As Double
        Dim r As Random = New Random(Module1.r.Next() And DateTime.Now.Millisecond)
        Dim x, y As Double
        Dim ilośćTrafień As Long = 0
        For i As Long = 0 To ilośćPrób - 1

            'synchronizacja na półmetku obliczeń wątku
            If i = ilośćPrób \ 2 Then
                'Użycie SyncLock do synchronizacji
                'SyncLock Module1.r
                '    Console.WriteLine("Synchronizacja: wątek nr {0} osiągnął półmetek",
                '                          Thread.CurrentThread.ManagedThreadId)
                'End SyncLock

                'Użycie Monitor do synchronizacji
                'Monitor.Enter(Module1.r)
                'Try
                '    Console.WriteLine("Synchronizacja: wątek nr {0} osiągnął półmetek", Thread.CurrentThread.ManagedThreadId)
                'Finally
                '    Monitor.Exit(Module1.r)
                'End Try
            End If

            x = r.NextDouble()
            y = r.NextDouble()
            If x * x + y * y < 1 Then ilośćTrafień += 1
            'Console.WriteLine("x={0}, y={1}", x, y)
        Next
        Return 4.0 * ilośćTrafień / ilośćPrób
    End Function

    Private Sub uruchamianieObliczenPi()
        Try
            Console.WriteLine("Uruchamianie obliczeń, wątek nr {0}...",
                  Thread.CurrentThread.ManagedThreadId)

            Dim czasPoczatkowy As Integer = Environment.TickCount

            Dim ilośćPrób As Long = 10000000L \ ileWatkow
            Dim pi As Double = obliczPi(ilośćPrób)
            Module1.pi += pi
            'Console.WriteLine("Pi={0}, błąd={1}", pi, Math.Abs(Math.PI - pi))
            Console.WriteLine("Pi={0}, błąd={1}, wątek nr {2}",
                      pi, Math.Abs(Math.PI - pi),
                      Thread.CurrentThread.ManagedThreadId)

            Dim czasKoncowy As Integer = Environment.TickCount
            Dim roznica As Integer = czasKoncowy - czasPoczatkowy
            'Console.WriteLine("Czas obliczeń: " & (roznica).ToString())
        Catch exc As ThreadAbortException
            Console.WriteLine("Działanie wątku zostało przerwane (" & exc.Message & ")")
        Catch exc As Exception
            Console.WriteLine("Wyjątek (" & exc.Message & ")")
        End Try
    End Sub
End Module
